/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.util.StringUtil;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.ui.MenuDialogItem;
import com.aptana.ui.QuickMenuDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class PullFromRemoteHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            return null;
        }
        ArrayList<MenuDialogItem> remoteBranches = new ArrayList<MenuDialogItem>();
        for (String remoteBranch : repo.remoteBranches()) {
            remoteBranches.add(new MenuDialogItem(remoteBranch));
        }
        if (!remoteBranches.isEmpty()) {
            QuickMenuDialog dialog = new QuickMenuDialog(this.getShell(), Messages.PullFromRemoteHandler_PopupTitle);
            dialog.setInput(remoteBranches);
            if (dialog.open() != -1) {
                MenuDialogItem item = (MenuDialogItem)remoteBranches.get(dialog.getReturnCode());
                PullFromRemoteHandler.pullFromRemoteBranch(repo, item.getText());
            }
        }
        return null;
    }

    public static void pullFromRemoteBranch(final GitRepository repo, String remoteBranch) {
        List parts = StringUtil.split((String)remoteBranch, (char)'/');
        final String remote = (String)parts.get(0);
        final String branch = (String)parts.get(1);
        Job job = new Job(NLS.bind((String)"git pull {0} {1}", (Object)remote, (Object)branch)){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (subMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return repo.pull(new String[]{remote, branch});
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
    }
}

